<?php
    $servername = "localhost";
    $dbname = "name";
    $username = "root";
    $password = "";
    $sql = "mysqli:host=$servername;dbname=$dbname";
    $dns_Option = [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION];

    //створюємо нове підключення до бази даних MySQL з використанням PDO,
    //$my_db_connection - це обєкт
    try{
        $my_db_connection = new PDO($sql, $username, $password, $dns_Option);
        echo "Connection ok";
    }catch (PDOException $error){
        echo 'Error connection' . $error->getMessage();
    }

    //Задаємо змінні для людини, котру хочемо додати до бази даних
    $first_name = "Test";
    $last_name = "Testing";
    $email = "test@ztu.edu.ua";

    //Тут створюємо змінну, що буде викликати метод prepare() обєкту бази даних
    //SQL запит, який ви хочсете запустити, він вводиться як параметр

    $my_insert_statement = $my_db_connection->prepare("INSERT INTO Students (name, lastName, email)
        VALUES (:first_name, :last_name, :email)");

    //Топірю ми повідомляємо нашому скрипту, на яку змінну фактично посилається кожен плейхолдер, використовуючи метод bindParam()
    //Перший параметр - це плейсхолдер, другий - змінна, на котру він повинен посилатись
    $my_insert_statement->bindParam(:first_name,:first_name);
    $my_insert_statement->bindParam(:last_name,:last_name);
    $my_insert_statement->bindParam(:last_name,:email);

    //виконуємо запит, використовуючі дані, котрі вище визначили
    //Метод execute() повертає TRUE, фкщо запит був успішний та FALSE якщо неуспішний
    if($my_insert_statement->execute()){
        echo "New record +";
    }else{
        echo "Unable to create";
    }

    //На настуному етапі можна змінити дані змінних та виконати запит наново, що б додати більше даних до БД
    $first_name = "John";
    $last_name = "Smidt";
    $email = "yyy@gmail.com";
    $my_insert_statement->execute();

    //Виконайте наново з новими змінними
    if($my_insert_statement->execute()){
        echo "New record +";
    }else{
        echo "Unable to create";
    }
