#include "iarduino_GPS_NMEA.h"																										//
																																	//
//		ЧТЕНИЕ ДАННЫХ NMEA ИЗ UART:																									//	Возвращаемое значение:	результат чтения (true/false).
bool	iarduino_GPS_NMEA::_read(uint8_t* arrSat, uint8_t arrSum, uint8_t arrCol, bool flgSat){										//	Параметры:				arrSat - указатель на начало массива данных о спутниках, arrSum - количество спутников, arrCol - количество данных о спутнике, flgSat - флаг получения данных только о спутниках участвующих в позиционировании).
		//	Стираем предыдущие данные:																								//
			if(_flgDataOld==false){																									//	Если флаг «_flgDataOld» позволяющий выводить старые данные сброшен, то ...
				latitude				= 0.0f;																						//	Сбрасываем предыдущие данные о широте							(± 90.0) N-северная  «+», S-южная    «-».
				longitude				= 0.0f;																						//	Сбрасываем предыдущие данные о долготе							(±180.0) E-восточная «+», W-западная «-».
				altitude				= 0;																						//	Сбрасываем предыдущие данные о высоте							(±32767) Над уровнем моря.
				speed					= 0;																						//	Сбрасываем предыдущие данные о скорости							(0-255)  км/ч.
				course					= 0.0f;																						//	Сбрасываем предыдущие данные о курсе							(±180.0°).
				seconds					= 0;																						//	Сбрасываем предыдущие данные о секундах							(0-59).
				minutes					= 0;																						//	Сбрасываем предыдущие данные о минутах							(0-59).
				Hours					= 0;																						//	Сбрасываем предыдущие данные о часах							(0-23).
				day						= 0;																						//	Сбрасываем предыдущие данные о дне месяца						(1-31).
				month					= 0;																						//	Сбрасываем предыдущие данные о месяце							(1-12).
				year					= 0;																						//	Сбрасываем предыдущие данные о годе								(0-99 без учёта века).
				Year					= 0;																						//	Сбрасываем предыдущие данные о годе								(0-65535 с учётом века).
				PDOP					= 50;																						//	Сбрасываем пространственный геометр. фактор ухудшения точности	(0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность).
				HDOP					= 50;																						//	Сбрасываем горизонтальный   геометр. фактор ухудшения точности	(0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность).
				VDOP					= 50;																						//	Сбрасываем вертикальный     геометр. фактор ухудшения точности	(0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность).
			}	available				= 0;																						//	Сбрасываем флаги чтения идентификаторов							(переменная состоит из битов указывающих о чтении индентификаторов: 0-GGA, 1-GLL, 2-RMC, 3-VTG, 4-ZDA, 5-DHV, 6-GST, 7-GSA1, 8-GSA2, 9-GSA3, 10-GSV, 11-TXT, 15-флаг устанавливается если один из учитываемых идентификаторов прочитан дважды значит прочитано всё сообщение NMEA).
				status[GPS_StatusGGA]	= '*';																						//	Сбрасываем символ указывающий на способ вычисления координат.
				status[GPS_StatusGLL1]	= '*';																						//	Сбрасываем символ указывающий на достоверность полученных координат.
				status[GPS_StatusGLL2]	= '*';																						//	Сбрасываем символ указывающий на способ вычисления координат.
				status[GPS_StatusRMC1]	= '*';																						//	Сбрасываем символ указывающий на достоверность полученных координат.
				status[GPS_StatusRMC2]	= '*';																						//	Сбрасываем символ указывающий на способ вычисления координат.
				status[GPS_StatusRMC3]	= '*';																						//	Сбрасываем символ указывающий на статус навигации.
				status[GPS_StatusVTG]	= '*';																						//	Сбрасываем символ указывающий на способ вычисления скорости и курса.
				status[GPS_StatusZDA]	= '*';																						//	Сбрасываем символ указывающий на достоверность полученной даты.
				satellites[GPS_VISIBLE]	= 0;																						//	Сбрасываем предыдущие данные о количестве наблюдаемых спутников	(0-255) наблюдаемые, участвующие в позиционировании.
				satellites[GPS_ACTIVE]	= 0;																						//	Сбрасываем предыдущие данные о количестве участвующих спутников	(0-255) наблюдаемые, участвующие в позиционировании.
			if(arrSum){ for(uint8_t i=0; i<(arrSum*arrCol); i++){ arrSat[i]=0; } }													//	Чистим массив данных о спутниках.
			if(_flgBegin){																											//	Если парсер был инициализирован, то ...
			//	Определяем временные переменные:																					//
				char     _tmpChar;																									//	Объявляем  переменную для временного хранения символа.			(прочитанного из строки).
				char     _strOperator[6];																							//	Объявляем  строку для хранения названия идентификатора NMEA.	("GNGGA", "GNGLL", "GNRMC" и т.д.).
				uint8_t  _satellites[6]	= {6,0,0,0,0,0};																			//	Определяем массив для хранения количества наблюдаемых спутников	(индекс,GPS-США,Глонасс-Россия,Galileo-Европа,Beidou-Китай,QZSS-Япония).
				float    _arrParam[20];																								//	Объявляем  массив для хранения значений параметров.				(символьные значения будут храниться как коды символов)
				uint8_t  _valParamSum	= 0;																						//	Определяем переменную для подсчёта количества параметров.		(количество параметров в одной строке).
				uint32_t _valParamFlg	= 0L;																						//	Определяем переменную для хранения флагов наличия параметров.	(флаги наличия данных параметров в одной строке).
				bool     _valParamSign	= false;																					//	Определяем влаг наличия отрицательного знака.					(true - отрицательный знак / false - нет отрицательного знака).
				uint8_t  _valCheckSum	= 0;																						//	Определяем переменную для подсчёта контрольной суммы.			(побитовое XOR всех символов строки NMEA между символами '$' и '*').
				uint8_t  _readCheckSum	= 0;																						//	Определяем переменную для чтения контрольной суммы.				(число строки находящееся после символа '*').
				uint32_t _timeOut		= millis() + _setTimeOut;																	//	Определяем переменную для хранения времени выхода из функции.
				float    _valPos		= 0;																						//	Определяем переменную для хранения позиции символа или цифры.	(символа в названии идентификатора, цифры после точки, или символа контрольной суммы).
			//	Выполняем чтение данных:																							//
				_objSerial->flush();																								//	Чистим буфер UART.
				while( (millis()<_timeOut) && !(available & 0x8000) ){																//	Читаем данные пока время millis() не достигнет значения «_timeOut» или пока не будут прочитаны все данные.
				//	Если в буфере UART есть данные от модуля:																		//
					if( _objSerial->available() ){																					//
					//	Читаем очередной символ из буфера UATR:																		//
						_tmpChar = _objSerial->read();																				//
					//	Начало строки:																								//
						if(_tmpChar=='$'){																							//
							_valParamSum = 0;																						//	Сбрасываем количество обнаруженных параметров.
							_valParamFlg = 0L;																						//	Сбрасываем флаги наличия данных в параметрах.
							_valCheckSum = 0;																						//	Сбрасываем значение рассчитанной контрольной суммы.
							_valPos      = 0.0f;																					//	Сбрасываем позицию символа в названии идентификатора, или цифры после точки.
						}else																										//
					//	Начало контрольной суммы:																					//
						if(_tmpChar=='*'){																							//
						//	Чтаем два символа контрольной суммы:																	//
							_valPos = 0.0f;																							//	Сбрасываем позицию символа контрольной суммы.
							while( (millis() < _timeOut) && (_valPos < 2.0f) ){														//	Читаем данные пока время «millis()» не достигнет значения «_timeOut» или не будет прочитано 2 символа.
								if( _objSerial->available() ){																		//
									_tmpChar = _objSerial->read(); _valPos += 1.0f;													//
									_readCheckSum = _readCheckSum * 0x10 + (_tmpChar-((_tmpChar>'9')?('A'-0x0A):'0'));				//
								}																									//
							}																										//
						//	Сравниваем контрольную сумму из строки с рассчитанной:													//
							if(_readCheckSum == _valCheckSum){																		//
							//	Если контрольная сумма совпала то парсим полученные данные:											//
			/* --GGA */			if( _strOperator[2]=='G' && _strOperator[3]=='G' && _strOperator[4]=='A' ){							//	Если строка «_strOperator» состоит из символов "--GGA" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0001 ){available |= 0x8000;} available |= 0x0001;									//	Устанавливаем флаг чтения опреатора "--GGA", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора GGA (Данные о последнем зафиксированном местоположении):				//
								//	Пример строки: $GNGGA,123456.789,1234.56789,N,12345.67890,E,1,12,1.2,123.4,M,1.2,M,,*12<CR><LF>	//	
								//	                      0          1          2 3           4 5 6  7   8     9 0   123			//
										if(_valParamFlg & (1L<< 0) ){ _parseTime(_arrParam[0]);								}		//	(0)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
										if(_valParamFlg & (1L<< 5) ){ status[GPS_StatusGGA]  = (uint8_t)_arrParam[5]+'0';	}		//	(5)		Сохраняем способ вычисления координат ('0'-недоступно, '1'-автономно, '2'-дифференциально, '3'-PPS, '4'-фиксированный RTK, '5'-не фиксированный RTK, '6'-экстраполяция, '7'-фиксированные координаты, '8'–режим симуляции).
										if(_valParamFlg & (1L<< 6) ){ satellites[GPS_ACTIVE] = (uint8_t)_arrParam[6];		}		//	(6)		Сохраняем количество спутников участвующих в позиционировании (00-12).
										if(_valParamFlg & (1L<< 7) ){ HDOP = _arrParam[7];									}		//	(7)		Сохраняем горизонтальный геометрический фактор ухудшения точности HDOP (X.X). 0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность.
									if( status[GPS_StatusGGA]>'0' || _flgDataOld==false ){											//			Сохраняем координаты и высоту только при способе вычисления координат выше '0' или если указано получать новые данные в любом случае.
										if(_valParamFlg & (1L<< 1) ){ latitude  = _parsePos(_arrParam[1],_arrParam[2]);		}		//	(1,2)	Сохраняем координаты по широте  ( ГГММ.МММММ) и направление широты  (N-север,  S-юг).
										if(_valParamFlg & (1L<< 3) ){ longitude = _parsePos(_arrParam[3],_arrParam[4]);		}		//	(3,4)	Сохраняем координаты по долготе (ГГГММ.МММММ) и направление долготы (E-восток, W-запад).
										if(_valParamFlg & (1L<< 8) ){ altitude  = _arrParam[8];								}		//	(8)		Сохраняем высоту над уровнем моря (XXX.X) geoid.
									}																								//
									//	if(_valParamFlg & (1L<< 9) ){ char     X = (uint8_t)  _arrParam[ 9]+'0';			}		//	(9)		Сохраняем единицы измерения высоты над уровнем моря ('М'-метры).
									//	if(_valParamFlg & (1L<<10) ){ float    X =            _arrParam[10];				}		//	(10)	Сохраняем разницу между эллипсоидом Земли WGS-84 и средним уровнем моря (X.X) geoid.
									//	if(_valParamFlg & (1L<<11) ){ char     X = (uint8_t)  _arrParam[11]+'0';			}		//	(11)	Сохраняем единицы измерения разницы между эллипсоидом Земли WGS-84 и средним уровнем моря ('М'-метры).
									//	if(_valParamFlg & (1L<<12) ){ float    X =            _arrParam[12];				}		//	(12)	Сохраняем количество секунд прошедших с получения последней DGPS поправки (SC104).
									//	if(_valParamFlg & (1L<<13) ){ uint16_t X = (uint16_t) _arrParam[13];				}		//	(13)	Сохраняем ID базовой станции (если используется режим DGPS).
								}																									//
			/* --GLL */			if( _strOperator[2]=='G' && _strOperator[3]=='L' && _strOperator[4]=='L' ){							//	Если строка «_strOperator» состоит из символов "--GLL" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0002 ){available |= 0x8000;} available |= 0x0002;									//	Устанавливаем флаг чтения опреатора "--GLL", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора GLL (Географические координаты):										//
								//	Пример строки: $GNGLL,1234.56789,N,12345.67890,E,123456.789,A,A*01<CR><LF>						//	
								//	                      0          1 2           3 4          5 6									//
										if(_valParamFlg & (1L<< 4) ){ _parseTime(_arrParam[4]);								}		//	(4)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
										if(_valParamFlg & (1L<< 5) ){ status[GPS_StatusGLL1] = (uint8_t)_arrParam[5]+'0';	}		//	(5)		Сохраняем достоверность полученных координат ('A'-данные достоверны (OK), 'V'-ошибочные данные).
										if(_valParamFlg & (1L<< 6) ){ status[GPS_StatusGLL2] = (uint8_t)_arrParam[6]+'0';	}		//	(6)		Сохраняем способ вычисления координат ('A'-автономный (OK), 'D'-дифференциальный, 'E'-аппроксимация, 'M'-фиксированные данные, 'N'-недостоверные данные).
									if( status[GPS_StatusGLL1]=='A' || _flgDataOld==false ){										//			Сохраняем координаты только при достоверности полученных координат 'A' или если указано получать новые данные в любом случае.
										if(_valParamFlg & (1L<< 0) ){ latitude  = _parsePos(_arrParam[0],_arrParam[1]);		}		//	(0,1)	Сохраняем координаты по широте  ( ГГММ.МММММ) и направление широты  (N-север,  S-юг).
										if(_valParamFlg & (1L<< 2) ){ longitude = _parsePos(_arrParam[2],_arrParam[3]);		}		//	(2,3)	Сохраняем координаты по долготе (ГГГММ.МММММ) и направление долготы (E-восток, W-запад).
									}																								//
								}																									//
			/* --RMC */			if( _strOperator[2]=='R' && _strOperator[3]=='M' && _strOperator[4]=='C' ){							//	Если строка «_strOperator» состоит из символов "--RMC" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0004 ){available |= 0x8000;} available |= 0x0004;									//	Устанавливаем флаг чтения опреатора "--RMC", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора RMC (Рекомендуемый минимум навигационных данных):						//
								//	Пример строки: $GNRMC,123456.789,A,1234.56789,N,12345.67890,E,1.23,12.34,123456,,,A,V*12<CR><LF>//
								//	                      0          1 2          3 4           5 6    7     8     90 1 2			//
										if(_valParamFlg & (1L<< 0) ){ _parseTime(_arrParam[0]);								}		//	(0)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
										if(_valParamFlg & (1L<< 8) ){ _parseDate(_arrParam[8]);								}		//	(8)		Сохраняем дату (ДДММГГ) в переменные day, month, year.
										if(_valParamFlg & (1L<< 1) ){ status[GPS_StatusRMC1] = (uint8_t)_arrParam[ 1]+'0';	}		//	(1)		Сохраняем достоверность полученных координат ('A'-данные достоверны (OK), 'V'-ошибочные данные).
										if(_valParamFlg & (1L<<11) ){ status[GPS_StatusRMC2] = (uint8_t)_arrParam[11]+'0';	}		//	(11)	Сохраняем способ вычисления координат ('A'-автономный (OK), 'D'-дифференциальный, 'E'-аппроксимация, 'M'-фиксированные данные, 'N'-недостоверные данные).
										if(_valParamFlg & (1L<<12) ){ status[GPS_StatusRMC3] = (uint8_t)_arrParam[12]+'0';	}		//	(12)	Сохраняем статус навигации (X).
									if( status[GPS_StatusRMC1]=='A' || _flgDataOld==false ){										//			Сохраняем координаты и скорость только при достоверности полученных координат 'A' или если указано получать новые данные в любом случае.
										if(_valParamFlg & (1L<< 2) ){ latitude  = _parsePos(_arrParam[2],_arrParam[3]);		}		//	(2,3)	Сохраняем координаты по широте  ( ГГММ.МММММ) и направление широты  (N-север,  S-юг).
										if(_valParamFlg & (1L<< 4) ){ longitude = _parsePos(_arrParam[4],_arrParam[5]);		}		//	(4,5)	Сохраняем координаты по долготе (ГГГММ.МММММ) и направление долготы (E-восток, W-запад).
										if(_valParamFlg & (1L<< 6) ){ speed     = _arrParam[6] * 1.852f;					}		//	(6)		Сохраняем скорость переведя её из узлов в км/ч.
										if(_valParamFlg & (1L<< 7) ){ course    = _arrParam[7];								}		//	(7)		Сохраняем курс на истинный полюс в градусах (XX.XX).
									}																								//
									//	if(_valParamFlg & (1L<< 9) ){ float    X =            _arrParam[ 9];				}		//	(9)		Сохраняем магнитное склонение в градусах.
									//	if(_valParamFlg & (1L<<10) ){ char     X = (uint8_t)  _arrParam[10]+'0';			}		//	(10)	Сохраняем направление магнитного склонения (E-вычесть / W-прибавить к истинному курсу).
								}																									//
			/* --VTG */			if( _strOperator[2]=='V' && _strOperator[3]=='T' && _strOperator[4]=='G' ){							//	Если строка «_strOperator» состоит из символов "--VTG" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0008 ){available |= 0x8000;} available |= 0x0008;									//	Устанавливаем флаг чтения опреатора "--VTG", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора VTG (Скорость и курс относительно земли):								//
								//	Пример строки: $GNVTG,12.34,T,,M,1.23,N,1.23,K,A*12<CR><LF>										//
								//	                      0     12 3 4    5 6    7 8												//
										if(_valParamFlg & (1L<< 8) ){ status[GPS_StatusVTG] = (uint8_t)_arrParam[8]+'0';	}		//	(8)		Сохраняем способ вычисления скорости и курса ('A'-автономный (OK), 'D'-дифференциальный, 'E'-аппроксимация, 'M'-фиксированные данные, 'N'-недостоверные данные).
									if( status[GPS_StatusVTG]=='A' || status[GPS_StatusVTG]=='D' ||									//			Сохраняем скорость и курс только при статусе 'A' или 'D' или
									    status[GPS_StatusVTG]=='E' || status[GPS_StatusVTG]=='M' || _flgDataOld==false ){			//			'E' или 'M' или если указано получать новые данные в любом случае.
										if(_valParamFlg & (1L<< 0) ){ course = _arrParam[0];								}		//	(0)		Сохраняем курс на истинный полюс в градусах (XX.XX).
										if(_valParamFlg & (1L<< 4) ){ speed  = _arrParam[4] * 1.852f;						}		//	(4)		Сохраняем скорость переведя её из узлов в км/ч.
										if(_valParamFlg & (1L<< 6) ){ speed  = _arrParam[6];								}		//	(6)		Сохраняем скорость в км/ч.
									}																								//
									//	if(_valParamFlg & (1L<< 1) ){ char     X = (uint8_t)  _arrParam[ 1]+'0';			}		//	(1)		Сохраняем флаг достоверности курса (T-true/F-false).
									//	if(_valParamFlg & (1L<< 2) ){ float    X =            _arrParam[ 2];				}		//	(2)		Сохраняем направление магнитного склонения в градусах (XX.XX).
									//	if(_valParamFlg & (1L<< 3) ){ char     X = (uint8_t)  _arrParam[ 3]+'0';			}		//	(3)		Сохраняем флаг (M-магнитный).
									//	if(_valParamFlg & (1L<< 5) ){ char     X = (uint8_t)  _arrParam[ 5]+'0';			}		//	(5)		Сохраняем единицы измерения скорости (4) (N-узлы).
									//	if(_valParamFlg & (1L<< 7) ){ char     X = (uint8_t)  _arrParam[ 7]+'0';			}		//	(7)		Сохраняем единицы измерения скорости (6) (K-км/ч).
								}																									//
			/* --ZDA */			if( _strOperator[2]=='Z' && _strOperator[3]=='D' && _strOperator[4]=='A' ){							//	Если строка «_strOperator» состоит из символов "--ZDA" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0010 ){available |= 0x8000;} available |= 0x0010;									//	Устанавливаем флаг чтения опреатора "--ZDA", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора ZDA (Дата и время):													//
								//	Пример строки: $GNZDA,123456.789,12,12,1234,12,12*12<CR><LF>									//
								//	                      0          1  2  3    4  5												//
										if(_valParamFlg & (1L<< 0) ){ _parseTime(_arrParam[0]);								}		//	(0)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
										if(_valParamFlg & (1L<< 1) ){ day        = (uint8_t)  _arrParam[1];					}		//	(1)		Сохраняем день (ДД).
										if(_valParamFlg & (1L<< 2) ){ month      = (uint8_t)  _arrParam[2];					}		//	(2)		Сохраняем месяц (ММ).
										if(_valParamFlg & (1L<< 3) ){ Year       = (uint16_t) _arrParam[3];					}		//	(3)		Сохраняем год с учётом века (ГГГГ).
									//	if(_valParamFlg & (1L<< 4) ){ uint8_t  X = (uint8_t)  _arrParam[4];					}		//	(4)		Сохраняем часовой пояс - часы (ЧЧ).
									//	if(_valParamFlg & (1L<< 5) ){ uint8_t  X = (uint8_t)  _arrParam[5];					}		//	(5)		Сохраняем часовой пояс - минуты (ММ).
										if((_valParamFlg& (1L<< 1) )&&(_valParamFlg & (1<< 2) )&&(_valParamFlg & (1<< 3) ) ) {		//	(1,2,3)	Если прочитаны день, месяц и год.
											if(status[GPS_StatusZDA]=='*'){status[GPS_StatusZDA]='V';}								//			Если дата или время ещё не читались, то указываем что теперь они читались.
											if(status[GPS_StatusZDA]=='V' && day && month && Year){status[GPS_StatusZDA]='D';}		//			Если дата или время читались, то указываем что дата прочитана корректно.
											if(status[GPS_StatusZDA]=='T' && day && month && Year){status[GPS_StatusZDA]='A';}		//			Если время прочитано корректно, то указываем что и дата прочитана корректно.
										}																							//
								}																									//
			/* --DHV */			if( _strOperator[2]=='D' && _strOperator[3]=='H' && _strOperator[4]=='V' ){							//	Если строка «_strOperator» состоит из символов "--DHV" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0020 ){available |= 0x8000;} available |= 0x0020;									//	Устанавливаем флаг чтения опреатора "--DHV", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора DHV (Скорость движения GNSS приемника):								//
								//	Пример строки: $GNDHV,123456.789,1.23,±1.234,±1.234,±1.234,±1.23,,,,,M*12<CR><LF>				//
								//	                      0          1     2      3      4      5        10							//
										if(_valParamFlg & (1L<< 0) ){ _parseTime(_arrParam[0]);								}		//	(0)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
									//	if(_valParamFlg & (1L<< 1) ){ float    X =            _arrParam[ 1];				}		//	(1)		Сохраняем скорость 3D     ( X.XX ) в м/с.
									//	if(_valParamFlg & (1L<< 2) ){ float    X =            _arrParam[ 2];				}		//	(2)		Сохраняем скорость ECEF-X (±X.XXX) в м/с.
									//	if(_valParamFlg & (1L<< 3) ){ float    X =            _arrParam[ 3];				}		//	(3)		Сохраняем скорость ECEF-Y (±X.XXX) в м/с.
									//	if(_valParamFlg & (1L<< 4) ){ float    X =            _arrParam[ 4];				}		//	(4)		Сохраняем скорость ECEF-Z (±X.XXX) в м/с.
									//	if(_valParamFlg & (1L<< 5) ){ float    X =            _arrParam[ 5];				}		//	(5)		Сохраняем скорость        ( X.XX ) в м/с.
									//	if(_valParamFlg & (1L<<10) ){ char     X = (uint8_t)  _arrParam[10]+'0';			}		//	(10)	
								}																									//
			/* --GST */			if( _strOperator[2]=='G' && _strOperator[3]=='S' && _strOperator[4]=='T' ){							//	Если строка «_strOperator» состоит из символов "--GST" (первые 2 символа могут быть любыми), то ...
								if( available & 0x0040 ){available |= 0x8000;} available |= 0x0040;									//	Устанавливаем флаг чтения опреатора "--GST", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора GST (Статистика ошибок позиционирования):								//
								//	Пример строки: $GNGST,114837.000,8.2,,,,35.3,26.8,19.3*12<CR><LF>								//
								//	                      0          1  234 5    6    7												//
										if(_valParamFlg & (1L<< 0) ){ _parseTime(_arrParam[0]);								}		//	(0)		Сохраняем время (ЧЧММСС.ССС) в переменные Hours, minutes, seconds.
									//	if(_valParamFlg & (1L<< 1) ){ float    X =            _arrParam[ 1];				}		//	(1)		Сохраняем среднее квадратическое значение (RMS) стандартной девиации диапазонов (X.X) в метрах.
									//	if(_valParamFlg & (1L<< 2) ){ float    X =            _arrParam[ 2];				}		//	(2)		Сохраняем ошибку элипса полуоси semi-major (X.X) в метрах.
									//	if(_valParamFlg & (1L<< 3) ){ float    X =            _arrParam[ 3];				}		//	(3)		Сохраняем ошибку элипса полуоси semi-minor (X.X) в метрах.
									//	if(_valParamFlg & (1L<< 4) ){ float    X =            _arrParam[ 4];				}		//	(4)		Сохраняем ошибку ориентации элипса полуоси (XXX.X) в градусах.
									//	if(_valParamFlg & (1L<< 5) ){ float    X =            _arrParam[ 5];				}		//	(5)		Сохраняем ошибку широты  (XX.X) в метрах.
									//	if(_valParamFlg & (1L<< 6) ){ float    X =            _arrParam[ 6];				}		//	(6)		Сохраняем ошибку долготы (XX.X) в метрах.
									//	if(_valParamFlg & (1L<< 7) ){ float    X =            _arrParam[ 7];				}		//	(7)		Сохраняем ошибку высоты  (XX.X) в метрах.
								}																									//
			/* --GSA */			if( _strOperator[2]=='G' && _strOperator[3]=='S' && _strOperator[4]=='A' ){							//	Если строка «_strOperator» состоит из символов "--GSA" (первые 2 символа могут быть любыми), то ...
								if( _arrParam[17]==1.0 ){ if(available & 0x0080){available |= 0x8000;} available |= 0x0080;}		//	Устанавливаем флаг чтения 1 сообщения опреатора "--GSA", а если он уже установлен, то устанавливаем флаг выхода из функции.
								if( _arrParam[17]==2.0 ){ if(available & 0x0100){available |= 0x8000;} available |= 0x0100;}		//	Устанавливаем флаг чтения 2 сообщения опреатора "--GSA", а если он уже установлен, то устанавливаем флаг выхода из функции.
								if( _arrParam[17]==3.0 ){ if(available & 0x0200){available |= 0x8000;} available |= 0x0200;}		//	Устанавливаем флаг чтения 3 сообщения опреатора "--GSA", а если он уже установлен, то устанавливаем флаг выхода из функции.
								//	Парсим значения опреатора GSA (Активные спутники и геометрические факторы ухудшения точности):	//
								//	Пример строки: $GNGSA,A,3,12,12,12,12,12,12,12,12,12,12,12,12,1.2,1.2,1.2,1*12<CR><LF>			//
								//	                      0 1 2  3  4  5  6  7  8  9  10 11 12 13 14  15  16  17					//
										if( arrSum && arrCol ){																		//			Если функция read() вызвана с указанием массива для получения данных о спутниках.
											for(uint8_t i=2, j; i<=13; i++){														//	(2-13)	Проходим по параметрам 2-13
												if(_valParamFlg & (1L<< i) ){														//	(2-13)	Если в очередном параметре есть ID спутника, то ...
													j=_findIndexID((uint8_t)_arrParam[i], arrSat, arrSum, arrCol);					//			Получаем номер свободного элемента массива «arrSat» или номер элемента уже содержащего ID = «_arrParam[i]».
													if(j<arrSum){																	//			Если полученный номер элемента массива «arrSat» не выходит за реальное количество элементов «arrSum», то ...
														if(arrCol>0){arrSat[(j*arrCol)+0]=(uint8_t)_arrParam[i];}					//			Сохраняем ID спутника «_arrParam[i]» в «j*arrCol» элемент массива «arrSat».
														if(arrCol>3){arrSat[(j*arrCol)+3]=1;}										//			Сохраняем Флаг активности спутника (0-видимый / 1-участвующий в позиционировании).
													}																				//
												}																					//
											}																						//
										}																							//
										if(_valParamFlg & (1L<<14) ){ PDOP       =            _arrParam[14];				}		//	(14)	Сохраняем пространственный геометрический фактор ухудшения точности PDOP (X.X). 0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность.
										if(_valParamFlg & (1L<<15) ){ HDOP       =            _arrParam[15];				}		//	(15)	Сохраняем горизонтальный   геометрический фактор ухудшения точности HDOP (X.X). 0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность.
										if(_valParamFlg & (1L<<16) ){ VDOP       =            _arrParam[16];				}		//	(16)	Сохраняем вертикальный     геометрический фактор ухудшения точности VDOP (X.X). 0-1 идеальная точность, 2-3 отличная точность, 4-6 хорошая точность, 7-8 средняя точность, 9-20 точность ниже среднего, 21-50 плохая точность.
									//	if(_valParamFlg & (1L<< 0) ){ char     X = (uint8_t)  _arrParam[ 0]+'0';			}		//	(0)		Сохраняем режим выбора формата 2D/3D (A-автоматический, M-ручной).
									//	if(_valParamFlg & (1L<< 1) ){ uint8_t  X = (uint8_t)  _arrParam[ 1];				}		//	(1)		Сохраняем режим выбранного формата (1-нет решения, 2-2D, 3-3D).
									//	if(_valParamFlg & (1L<<17) ){ char     X = (uint8_t)  _arrParam[17]+'0';			}		//	(17)	Сохраняем номер спутниковой навигационной системы (1-GPS, 2-Glonass, 3-Galileo, 4-Beidu).
								}																									//
			/* --GSV */			if( _strOperator[2]=='G' && _strOperator[3]=='S' && _strOperator[4]=='V' ){							//	Если строка «_strOperator» состоит из символов "--GSV" (первые 2 символа могут быть любыми), то ...
								available |= 0x0400;																				//	Устанавливаем флаг чтения опреатора "--GSV".
								//	Парсим значения опреатора GSV (Информация о всех наблюдаемых спутниках):						//
								//	Пример строки: $--GSV,1,1,12,12,12,123,12,12,12,123,12,12,12,123,12,12,12,123,12,0*12<CR><LF>	//
								//	                      0 1 2  3  4  5   6  7  8  9   10 11 12 13  14 15 16 17  18 19				//
										                                                  _satellites[0]=6;							//	(--)	Текущая строка идентификатора "GSV" содержит информацию о спутниках неизвестной навигационной системы.
										if( _strOperator[0]=='G' && _strOperator[1]=='P'){_satellites[0]=1;}						//	(GP)	Текущая строка идентификатора "GSV" содержит информацию о спутниках GPS     - США.
										if( _strOperator[0]=='G' && _strOperator[1]=='L'){_satellites[0]=2;}						//	(GL)	Текущая строка идентификатора "GSV" содержит информацию о спутниках Глонасс - Россия.
										if( _strOperator[0]=='G' && _strOperator[1]=='A'){_satellites[0]=3;}						//	(GA)	Текущая строка идентификатора "GSV" содержит информацию о спутниках Galileo - Европа.
										if( _strOperator[0]=='B' && _strOperator[1]=='D'){_satellites[0]=4;}						//	(BD)	Текущая строка идентификатора "GSV" содержит информацию о спутниках Beidou  - Китай.
										if( _strOperator[0]=='G' && _strOperator[1]=='Q'){_satellites[0]=5;}						//	(GQ)	Текущая строка идентификатора "GSV" содержит информацию о спутниках QZSS    - Япония.
										if(_valParamFlg & (1L<<2) ){if(_satellites[0]<6){_satellites[_satellites[0]]=_arrParam[2];}}//	(2)		Сохраняем количество наблюдаемых спутников.
										if( arrSum && arrCol ){																		//			Если функция read() вызвана с указанием массива для получения данных о спутниках.
											for(uint8_t i=3, j, k; i<=18; i+=4){													//	(3-18)	Проходим по параметрам 3-6, 7-10, 11-14, 15-18.
												if(_valParamSum > (i+4)){															//			Если осталось ещё 4 параметра, чего достаточно для получения информации об очередном спутнике.
													if(_valParamFlg & (1L<<i) ){													//	(3,7,11,15)	Если в очередном параметре есть ID спутника, то ...
														j=_findIndexID((uint8_t)_arrParam[i], arrSat, arrSum, arrCol);				//			Получаем номер свободного элемента массива «arrSat» или номер элемента уже содержащего ID = «_arrParam[i]».
														k=_findIndexID(0                    , arrSat, arrSum, arrCol);				//			Получаем номер свободного элемента массива «arrSat».
														if(flgSat==false || j<k){													//			Если сброшен флаг flgSat, что позволяет сохранять данные о всех спутниках, или ID спутника уже имеется в массиве «arrSat», то ...
															if(j<arrSum){															//			Если полученный номер элемента массива «arrSat» не выходит за реальное количество элементов «arrSum», то ...
															//	_arrParam[ i+0=ID, i+1=Угол, i+2=Азимут, i+3=SNR ].					//
																if(arrCol>0){arrSat[(j*arrCol)+0]=(uint8_t)_arrParam[i];}			//			Сохраняем ID спутника «_arrParam[i]» в «j*arrCol» элемент массива «arrSat».
																if(arrCol>1){arrSat[(j*arrCol)+1]=(uint8_t)_arrParam[i+3];}			//			Сохраняем отношение сигнал/шум (SNR) в дБ.
																if(arrCol>2){arrSat[(j*arrCol)+2]=_satellites[0]<6?_satellites[0]:0;}//			Сохраняем тип навигационной системы спутника (0-неизвестен, 1-GPS, 2-Глонасс, 3-Galileo, 4-Beidou, 5-QZSS).
															//	if(arrCol>3){arrSat[(j*arrCol)+3]=1;}								//			Не сохраняем Флаг активности спутника (0-видимый / 1-участвующий в позиционировании), так как указанный флаг сохранён при парсинге идентификатора «GSA».
																if(arrCol>4){arrSat[(j*arrCol)+4]=(uint8_t)_arrParam[i+1];}			//			Сохраняем угол возвышения спутника (0°-горизонт / 90°-зенит).
																if(arrCol>5){arrSat[(j*arrCol)+5]=(uint8_t)(_arrParam[i+2]>255? 255:(uint8_t)_arrParam[i+2]);}//	Сохраняем азимут положения спутника (0°-255°).
																if(arrCol>6){arrSat[(j*arrCol)+6]=(uint8_t)(_arrParam[i+2]<=255? 0 :(uint8_t)_arrParam[i+2]);}//	Сохраняем азимут положения спутника (остаток до 360°).
															}																		//
														}																			//
													}																				//
												}																					//
											}																						//
										}																							//
									//	if(_valParamFlg & (1L<<0) ){ uint8_t  X = (uint8_t)  _arrParam[ 0];				}			//	(0)		Сохраняем количество сообщений (1-9).
									//	if(_valParamFlg & (1L<<1) ){ uint8_t  X = (uint8_t)  _arrParam[ 1];				}			//	(1)		Сохраняем номер сообщения (1-9).
								}																									//
			/* --TXT */			if( _strOperator[2]=='T' && _strOperator[3]=='X' && _strOperator[4]=='T' ){							//	Если строка «_strOperator» состоит из символов "--TXT" (первые 2 символа могут быть любыми), то ...
								available |= 0x0800;																				//	Устанавливаем флаг чтения опреатора "--TXT".
								}																									//
							}																										//
						}else																										//
					//	Завершение строки:																							//
						if(_tmpChar=='\r' || _tmpChar=='\n'){																		//
																																	//
						}else{																										//
					//	Читаем значения строки:																						//
							_valCheckSum ^= _tmpChar;																				//	Вычисляем контрольную сумму
						//	Начало очередного параметра:																			//
							if(_tmpChar==','){																						//	Параметры отделяются друг от друга символом ','.
								_valPos=0.0f; _valParamSum++; if(_valParamSum>20){_valParamSum=20;} _arrParam[_valParamSum-1]=0.0f;	//	Сбрасываем позицию символа после точки и определяем номер очередного параметра строки.
								_valParamSign=false;																				//
							}else																									//
						//	Параметр содержит значение с дробной частью:															//
							if(_tmpChar=='.'){																						//
								_valPos=0.1f;																						//	Устанавливаем позицию символа после точки.
							}else																									//
						//	Читаем значение параметра:																				//
							if(_valParamSum==0){																					//	Если номер параметра «_valParamSum» равен 0, значит от следует после '$' и до ','.
							//	Читаем название идентификатора:																		//
								if(_valPos<5){																						//	Если в строке «_strOperator» еще есть свободное место.
									_strOperator[(uint8_t)_valPos]=_tmpChar; _valPos+=1.0f; _strOperator[(uint8_t)_valPos]=0;		//	Читаем очередной символ названия идентификатора и добавляем символ конца строки.
								}																									//
							}else{																									//	Если номер параметра «_valParamSum» больше 0, значит от следует через ',' после '$'.
							//	Читаем содержимое параметра:																		//
								_valParamFlg |= (1L<<(_valParamSum-1));																//	Устанавливаем флаг наличия данных в параметре.
								if(_tmpChar=='-'){_valParamSign=true;}else															//	Устанавливаем флаг наличия данных с отрицательным знаком.
								{																									//	
									if(_valPos==0.0f){_arrParam[_valParamSum-1]= _arrParam[_valParamSum-1]*10+((float)(_tmpChar-'0')*(_valParamSign?-1.0f:1.0f));}	//	Получаем целую   часть числа.
									else             {_arrParam[_valParamSum-1]+= (float)(_tmpChar-'0') * _valPos * (_valParamSign?-1.0f:1.0f); _valPos/=10; }		//	Получаем дробную часть числа.
								}																									//
							}																										//
						}																											//
					}																												//
				}																													//
			//	Определяем временную зону по координатам:																			//
				if( _flgAutoTimeZone ){																								//	Если указано определять временную зону по координатам.
					if( status[GPS_StatusGGA]>'0'||status[GPS_StatusGLL1]=='A'||status[GPS_StatusRMC1]=='A'||_flgDataOld==false ){	//	Определяем временную зону только при способе вычисления координат выше '0', достоверности полученных координат 'A' или если указано получать новые данные в любом случае.
						_timeZone = (float)((int16_t)((longitude+(7.5f*(longitude>0?1.0f:-1.0f)))/15.0f));							//	0.00°-7.49° = +0, 7.50°-22.49° = +1, 22.50°-37.49° = +2, 37.50°-52.49° = +3, ...
					}																												//
				}																													//
			//	Определяем недостающие параметры даты и времени:																	//
				if(Year==0){Year = (uint16_t)year + 100*(GPS_Century-1);}															//	Определяем год в формате YYYY, если он не был прочитан.
				_TimeToUnix();																										//	Определяем количество секунд прошедших с начала эпохи Unix.
				if( ( status[GPS_StatusZDA] == 'A') || ( status[GPS_StatusZDA] == 'T') ){											//	Временную зону добавляем только к достоверным данным времени.
					Unix += ((int32_t)(_timeZone*100)%100)*36;																		//	Добавляем минуты временной зоны к времени Unix.
					Unix +=  (int32_t)(_timeZone)*3600;																				//	Добавляем часы   временной зоны к времени Unix.
				}																													//
				_UnixToTime();																										//	Определяем время из секунд прошедших с начала эпохи Unix.
			//	Заполняем данные не читаемые из строк NMEA или требующие корректировки:												//
				satellites[GPS_VISIBLE]=_satellites[1]+_satellites[2]+_satellites[3]+_satellites[4]+_satellites[5];					//	Определяем количество наблюдаемых спутников как сумма обнаруженных спутников навигационных систем: GPS-США + Глонасс-Россия + Galileo-Европа + Beidou-Китай + QZSS-Япония.
				if(satellites[GPS_VISIBLE]<satellites[GPS_ACTIVE]){ satellites[GPS_VISIBLE] = satellites[GPS_ACTIVE]; }				//	Если количество наблюдаемых спутников меньше чем активных, то указываем их количество равным количеству спутников участвующих в позиционировании.
				if( arrSum && arrCol ){ for(uint8_t i=0, j=0, k=0; i<arrSum; i++){if(arrSat[(i*arrCol)  ]>0 ){j++;} if(arrCol>3){ if(arrSat[(i*arrCol)+3]>0 ){k++;} if(satellites[GPS_VISIBLE]<j){satellites[GPS_VISIBLE]=j;} if(satellites[GPS_ACTIVE]<k){satellites[GPS_ACTIVE]=k;}}}}
				if(course>180){course=360-course;}																					//	Корректируем курс от значения 0-360° к значению ±180°.
			//	Определяем наличие ошибок:																							//
				errTim=available?2:1;	if( status[GPS_StatusZDA ]=='A' || status[GPS_StatusZDA ]=='T' ){errTim=0;}					//	Определяем флаг указывающий на то, что полученное время недостоверно.
				errDat=available?2:1;	if( status[GPS_StatusZDA ]=='A' || status[GPS_StatusZDA ]=='D' ){errDat=0;}					//	Определяем флаг указывающий на то, что полученная дата  недостоверна.
				errCrs=available?2:1;	if( status[GPS_StatusVTG ]=='A' || status[GPS_StatusVTG ]=='D' ){errCrs=0;}					//	Определяем флаг указывающий на то, что не определён способ вычисления скорости и курса.
										if( status[GPS_StatusVTG ]=='E' || status[GPS_StatusVTG ]=='M' ){errCrs=0;}					//	Определяем флаг указывающий на то, что не определён способ вычисления скорости и курса.
										if( status[GPS_StatusGGA ] >'0' || status[GPS_StatusRMC1]=='A' ){errCrs=0;}					//	Определяем флаг указывающий на то, что не определён способ вычисления скорости и курса.
				errPos=available?2:1;	if( status[GPS_StatusGLL1]=='A' || status[GPS_StatusRMC1]=='A' ){errPos=0;}					//	Определяем флаг указывающий на то, что не определён способ вычисления координат, или полученные координаты недостоверны.
										if( status[GPS_StatusGGA ] >'0'                                ){errPos=0;}					//	Определяем флаг указывающий на то, что не определён способ вычисления координат, или полученные координаты недостоверны.
			}	return available?1:0;																								//
}																																	//
																																	//
//		ОБНАРУЖЕНИЕ ID СПУСНИКА СРЕДИ ЭЛЕМЕНТОВ ВНЕШНЕГО МАССИВА:																	//	Возвращаемое значение:	индекс массива (0-255).
uint8_t	iarduino_GPS_NMEA::_findIndexID(uint8_t id, uint8_t* arrSat, uint8_t arrSum, uint8_t arrCol){								//	Параметры:				id - искомый ID, arrSat - указатель на начало массива данных о спутниках, arrSum - количество спутников, arrCol - количество данных о спутнике).
			for(uint8_t i=0; i<arrSum; i++){																						//
				if(arrSat[(i*arrCol)]==0 ){return i;}																				//	Возвращаем номер пустого элемент массива.
				if(arrSat[(i*arrCol)]==id){return i;}																				//	Возвращаем номер элемента массива уже содержащего ID спутника.
			}																														//
			return 0xFF;																											//	Возвращаем номер не существующего элемента массива.
}																																	//
																																	//
//		ФУНКЦИИ ОПРЕДЕЛЕНИЯ ВРЕМЕНИ UNIX:																							//
void	iarduino_GPS_NMEA::_UnixToTime(void){																						//	Получение времени из секунд Unix.
			uint32_t i	= Unix; uint32_t j; uint8_t k; bool f=true;																	//	Объявляем временные переменные.
			seconds		=  i          % 60;																							//  Получаем текущее значение секунд.						(остаток от деления секунд прошедших с начала эпохи Unix на количество секунд в минуте)
			i			= (i-seconds) / 60;																							//  Получаем количество минут прошедших с начала эпохи Unix.
			minutes		=  i          % 60;																							//  Получаем текущее значение минут.						(остаток от деления минут  прошедших с начала эпохи Unix на количество минут в часе)
			i			= (i-minutes) / 60;																							//  Получаем количество часов прошедших с начала эпохи Unix.
			Hours		=  i          % 24;																							//  Получаем текущее значение часов.						(остаток от деления часов  прошедших с начала эпохи Unix на количество часов в дне)
			hours		= Hours-((Hours>12)?12:0); if(hours==0){hours=12;}															//	Определяем переменную для хранения часов				(1-12).
			midday		= ((Hours>0)&&(Hours<13))?0:1;																				//	Определяем переменную для хранения полденя				(0-am, 1-pm).
			i			= (i-Hours)   / 24;																							//  Получаем количество  дней прошедших с начала эпохи Unix.
			j			=  0; while((((j+1)*365)+((j+2)/4))<=i){j++;}																//	Получаем количество   лет прошедших с начала эпохи Unix.
			weekday		= (i+4) % 7;																								//	Получаем текущий день недели.							(0-воскресенье, 1-понедельник, ... , 6-суббота)
			i			=  i - (j*365) - ((j+1)/4);																					//	Получаем количество  дней прошедших в текущем году.
			Year		=  (1970+j);																								//	Получаем текущий год с учётом века.
			year		=  Year%100;																								//	Получаем текущий год  без учёта века.
			k			= (Year%4)==0?29:28;																						//	Получаем количество дней в феврале текущего года.
			month		= 0; while(f){month++; j=month; j=(((j+1)%2)^(j<8))?31:(j==2?k:30); if(i>=j){i-=j;}else{f=false;}}			//	Получаем текущий месяц.
			day			= i+1;																										//	Получаем текущий день.
}																																	//
void	iarduino_GPS_NMEA::_TimeToUnix(void){																						//	Получение секунд Unix из времени.
			Unix		= Year - 1970;																								//  Определяем количество прошедших лет				(с 01.01.1970 г.)
			Unix		= Unix * 365 + ((Unix+1)/4);																				//  Определяем количество дней в прошедших годах	((Unix+1)/4) - количество прошедших високосных лет (без учёта текущего года).
			Unix		+= (month-1)*30 + ( (month + (month<9?0:1) )/2 );															//  Добавляем  количество дней в прошедших месяцах	((month+(month<9?0:1))/2) - количество прошедших месяцев текущего года, содержащих 31 день.
			Unix		-= month>2? (Year%4==0?1:2) : 0;																			//  Вычитаем   1 или 2 дня из февраля текущего года	((month>2) - если февраль уже прошел, j%4==0 - если текущий год високосный)
			Unix		+= day-1;																									//  Добавляем  количество прошедших дней этого месяца
			Unix		*= 86400;																									//	Получаем   количество секунд прошедших дней
			Unix		+= (uint32_t)Hours * 3600 + (uint32_t)minutes * 60 + seconds;												//	Добавляем  количество секунд текущего дня
}																																	//
