// ПРИМЕР ПОЗВОЛЯЕТ ВЫЯВИТЬ ОШИБКИ РАБОТЫ МОДУЛЯ: //
                                                  //
const uint8_t pinRX = 8;                          //  Определяем вывод RX (программного UART) на плате Arduino к которому подключён вывод TX модуля. Номер вывода можно изменить.
const uint8_t pinTX = 9;                          //  Определяем вывод TX (программного UART) на плате Arduino к которому подключён вывод RX модуля. Номер вывода можно изменить.
                                                  //
#include <SoftwareSerial.h>                       //  Подключаем библиотеку для работы с программным UART, до подключения библиотеки iarduino_GPS_NMEA.
#include <iarduino_GPS_NMEA.h>                    //  Подключаем библиотеку для расшифровки строк протокола NMEA получаемых по UART.
                                                  //
SoftwareSerial    SerialGPS(pinRX, pinTX);        //  Объявляем объект SerialGPS для работы с функциями и методами библиотеки SoftwareSerial, указав выводы RX и TX Arduino.
iarduino_GPS_NMEA gps;                            //  Объявляем объект gps для работы с функциями и методами библиотеки iarduino_GPS_NMEA.
                                                  //
void setup(){                                     //
     Serial.begin(9600);                          //  Инициируем работу с аппаратной шиной UART для вывода данных в монитор последовательного порта на скорости 9600 бит/сек.
     SerialGPS.begin(9600);                       //  Инициируем работу с программной шиной UART для получения данных от GPS модуля на скорости 9600 бит/сек.
     gps.begin(SerialGPS);                        //  Инициируем расшифровку строк NMEA указав объект используемой шины UART (вместо программной шины, можно указывать аппаратные: Serial, Serial1, Serial2, Serial3).
}                                                 //
                                                  //
void loop(){                                      //
     uint32_t i = millis();                       //
     bool     j = gps.read();                     //  Читаем сообщение NMEA получая флаг результата чтения.
     uint16_t k = gps.available;                  //  Получаем флаги наличия идентификаторов строк в прочитанном сообщении NMEA.
//   Проверяем наличие связи с GPS-модулем:       //
     if( !j ){                                    //
         Serial.println("Данные не прочитаны");   //  Если в мониторе последовательного порта появилось данное сообщение,
         return;                                  //  значит модуль не подключён или указана некорректная скорость UART.
     }                                            //
//   Выводим время выполнения чтения:             //
     Serial.print("Данные прочитаны за ");        //
     Serial.print((float)(millis()-i)/1000,3);    //  Выводим время за которое функция read() прочитала сообщение NMEA.
     Serial.print(" секунд. ");                   //
//   Выводим состав прочитанного сообщения NMEA:  //
     Serial.print("Сообщение содержит строки: "); //  Заполнение переменных функцией read() зависит от наличия соответствующих строк в сообщении NMEA.
     if( k & bit(0)  ){ Serial.print("GGA, "); }  //  Если Вы не видите требуемые Вам идентификаторы, настройте работу GPS-модуля, например, функцией 
     if( k & bit(1)  ){ Serial.print("GLL, "); }  //  composition() библиотеки iarduino_GPS_ATGM336 (если Вы пользуетесь GPS-модулем ATGM336).
     if( k & bit(2)  ){ Serial.print("RMC, "); }  //
     if( k & bit(3)  ){ Serial.print("VTG, "); }  //
     if( k & bit(4)  ){ Serial.print("ZDA, "); }  //
     if( k & bit(5)  ){ Serial.print("DHV, "); }  //
     if( k & bit(6)  ){ Serial.print("GST, "); }  //
     if( k & bit(7)  ){ Serial.print("GSA, "); }  //
     if( k & bit(8)  ){ Serial.print("GSA, "); }  //
     if( k & bit(9)  ){ Serial.print("GSA, "); }  //
     if( k & bit(10) ){ Serial.print("GSV, "); }  //
     if( k & bit(11) ){ Serial.print("TXT, "); }  //
//   Проверяем прочитано ли сообщение полностью:  //
     if( k & bit(15) ){                           //
     Serial.println("чтение выполнено полностью");//
     }else{                                       //
     Serial.println("чтение выполнено частично"); //  Если в мониторе последовательного порта появилось данное сообщение,
     }                                            //  то увеличте время выполнения чтения функцией timeOut().
}                                                 //